clear all

* Set Folder to input one

cd ..\Inputs

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "GDPC1.xls", ///
sheet(FRED Graph) cellrange(B11) firstrow clear

save GDPC1, replace

* Import real potential GDP estimates from CBO (obtained from ALFRED)

import excel "CBO Real Potential GDP.xls", ///
sheet(Vintages) cellrange(A1) firstrow clear

* Generate date variables and rearrange

rename observation_date date
gen year=year(date)
gen month=month(date)
gen day=day(date)
drop if year<1960
egen tt=group(date)
order date tt year month day

joinby year month using GDPC1, unmatched(master)
tab _merge
drop _merge

gen time=year+(month-1)/12

foreach var in 	GDPPOT_19910130 GDPPOT_19920122 GDPPOT_19930126 ///
				GDPPOT_19940127 GDPPOT_19950201 GDPPOT_19960417 ///
				GDPPOT_19970128 GDPPOT_19980128 GDPPOT_19990129 ///
				GDPPOT_20000127 GDPPOT_20010201 GDPPOT_20020201 ///
				GDPPOT_20030304 GDPPOT_20040127 GDPPOT_20050125 ///
				GDPPOT_20060126 GDPPOT_20070124 GDPC1 {
	gen log_`var'=log(`var')
	sum log_`var' if year==1994 & month==1
	replace log_`var'=log_`var'-r(mean)
}
		
twoway ///
(line log_GDPPOT_19950201 time if time>=1993 & time<=2005, lcolor(red)) ///
(line log_GDPPOT_19970128 time if time>=1993 & time<=2005, lcolor(green) lpattern(dash_dot)) ///
(line log_GDPPOT_19990129 time if time>=1993 & time<=2005, lcolor(blue) lpattern(dash)) ///
(line log_GDPPOT_20010201 time if time>=1993 & time<=2005, lcolor(black) lpattern(shortdash)) ///
(line log_GDPPOT_20030304 time if time>=1993 & time<=2005, lcolor(purple) lpattern(shortdash_dot)) ///
(line log_GDPC1 time if time>=1993 & time<=2005, lcolor(black) lwidth(thick)) ///		
, ///
xlabel(1993(1)2005) xtitle("") ///
ylabel(-0.05(0.05)0.35) ytitle("log deviation from 1994Q1") ///
legend(	label(1 "CBO 1995") label(2 "CBO 1997") label(3 "CBO 1999") ///
label(4 "CBO 2001") label(5 "CBO 2003") ///
label(6 "actual") ring(0) position(5) rows(4)) ///
graphregion(color(white)) bgcolor(white)	
